﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class PromotionDetailsDB
    {
        public static PromotionDetails GetItem(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionDetailsID", ((promotionDetailsID != Guid.Empty && promotionDetailsID != null) ? promotionDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductsID", ((productID != Guid.Empty && productID != null) ? productID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<PromotionDetails>("spGetPromotionDetails", parameters);
        }

        public static List<PromotionDetails> GetList(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionDetailsID", ((promotionDetailsID != Guid.Empty && promotionDetailsID != null) ? promotionDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductsID", ((productID != Guid.Empty && productID != null) ? productID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<PromotionDetails>("spGetPromotionDetails", parameters);
        }

        public static DataTable GetDataTable(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionDetailsID", ((promotionDetailsID != Guid.Empty && promotionDetailsID != null) ? promotionDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductsID", ((productID != Guid.Empty && productID != null) ? productID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetPromotionDetails", parameters);
        }

        public static DataSet GetDataSet(Guid promotionDetailsID, Guid promotionID, Guid productID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionDetailsID", ((promotionDetailsID != Guid.Empty && promotionDetailsID != null) ? promotionDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromotionID", ((promotionID != Guid.Empty && promotionID != null) ? promotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductsID", ((productID != Guid.Empty && productID != null) ? productID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetPromotionDetails", parameters);
        }

        public static void Save(PromotionDetails myspGetPromotionDetails)
        {
            myspGetPromotionDetails.Mode = ((myspGetPromotionDetails.UniqueID != Guid.Empty && myspGetPromotionDetails.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myspGetPromotionDetails.UniqueID = ((myspGetPromotionDetails.UniqueID != Guid.Empty && myspGetPromotionDetails.UniqueID != null) ? myspGetPromotionDetails.UniqueID : Guid.NewGuid());
            if (myspGetPromotionDetails.Mode == GlobalConfigurations.Mode.Insert)
            {
                myspGetPromotionDetails.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromotionDetailsID", myspGetPromotionDetails.UniqueID));
            parameters.Add(new SqlParameter("@PromotionID", ((myspGetPromotionDetails.PromotionID != Guid.Empty && myspGetPromotionDetails.PromotionID != null) ? myspGetPromotionDetails.PromotionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductsID", ((myspGetPromotionDetails.ProductsID != Guid.Empty && myspGetPromotionDetails.ProductsID != null) ? myspGetPromotionDetails.ProductsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromoType", (string.IsNullOrEmpty(myspGetPromotionDetails.PromoType) ? (object)DBNull.Value : myspGetPromotionDetails.PromoType)));
            parameters.Add(new SqlParameter("@DiscountType", (string.IsNullOrEmpty(myspGetPromotionDetails.DiscountType) ? (object)DBNull.Value : myspGetPromotionDetails.DiscountType)));
            parameters.Add(new SqlParameter("@Discount", (myspGetPromotionDetails.Discount == 0 ? (object)DBNull.Value : myspGetPromotionDetails.Discount)));
            parameters.Add(new SqlParameter("@BuyingQty", (myspGetPromotionDetails.BuyingQty == 0) ? (object)DBNull.Value : myspGetPromotionDetails.BuyingQty));
            parameters.Add(new SqlParameter("@DiscountQty", (myspGetPromotionDetails.DiscountQty == 0) ? (object)DBNull.Value : myspGetPromotionDetails.DiscountQty));
            parameters.Add(new SqlParameter("@CreatedBy", ((myspGetPromotionDetails.UserAccountID != Guid.Empty && myspGetPromotionDetails.UserAccountID != null) ? myspGetPromotionDetails.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myspGetPromotionDetails.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdatePromotionDetails", parameters);
        }
    }
}
